/**
 * @file: mspin_core_adapter.h
 *
 * @version: $Id:$
 *
 * @release: $Name:$
 *
 * MySpin Core Adapter
 *
 * @component: MSPIN
 *
 * @author: Thilo Bjoern Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * @copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * @history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_CORE_ADAPTER_H_
#define MSPIN_CORE_ADAPTER_H_

#include "mspin_typedef.h"
#include "mspin_appl_if_adapter.h"

typedef void (*coreStarted_CB)(void* token, MSPIN_ERROR result);

void mspin_core_asyncStart(mspin_context_t *pContext, coreStarted_CB coreStartedCB, void *token);

void mspin_core_asyncStop(mspin_context_t *pContext);

MSPIN_ERROR mspin_core_start(mspin_context_t *pContext);

void* mspin_core_stopCoreInstance(mspin_context_t *pContext);

void mspin_core_deleteCoreInstance(mspin_context_t *pContext, void *pCore);

void mspin_core_requestFrameUpdate(mspin_context_t *pContext, bool incremental);

MSPIN_ERROR mspin_core_createLMContext(mspin_context_t *pContext);

void mspin_core_deleteLMContext(mspin_context_t *pContext);

#endif /* MSPIN_CORE_ADAPTER_H_ */
